#include <iostream>
#include <algorithm>
#include <vector>
#include <queue>
#include <map>
#include <set>

using namespace std;

#define int long long

struct edge_t {
    int to, weight, number;

    edge_t(int t = 0, int w = 0, int number = 0) :
            to(t),
            weight(w),
            number(number) {
    }
};

int const LIM = 20001, INF = 1e18;

int n, m, d[LIM], timer, tin[LIM], fup[LIM];
bool used[LIM];
vector<edge_t> g[LIM];
vector<pair<int, int>> parent[LIM], g1[LIM];
set<int> cut;

void dijkstra(int start) {
    fill(d, d + n, INF);
    d[start] = 0;
    priority_queue<pair<int, int>, vector<pair<int, int>>, greater<pair<int, int>>> q;
    q.push(make_pair(0, start));
    while (!q.empty()) {
        int u = q.top().second, l = q.top().first;
        q.pop();
        if (l > d[u])
            continue;
        for (edge_t const &e : g[u]) {
            if (d[e.to] > d[u] + e.weight) {
                parent[e.to].clear();
                parent[e.to].push_back(make_pair(u, e.number));
                d[e.to] = d[u] + e.weight;
                q.push(make_pair(d[e.to], e.to));
            } else if (d[e.to] == d[u] + e.weight) {
                parent[e.to].push_back(make_pair(u, e.number));
            }
        }
    }
}

void make_graph(int u) {
    used[u] = true;
    for (pair<int, int> const &v : parent[u]) {
        g1[u].push_back(v);
        g1[v.first].push_back(make_pair(u, v.second));
        if (!used[v.first]) {
            make_graph(v.first);
        }
    }
}

void dfs(int u, int p_number = -1) {
    //cout << ": " << u + 1 << ' ' << p + 1 << endl;
    used[u] = true;
    tin[u] = fup[u] = timer++;
    for (pair<int, int> const &pt : g1[u]) {
        int v = pt.first, number = pt.second;
        if (!used[v]) {
            dfs(v, number);
            if (fup[v] > tin[u]) {
                cut.insert(number);
            }
            fup[u] = min(fup[u], fup[v]);
        } else if (p_number != number) {
            fup[u] = min(fup[u], tin[v]);
        }
    }
}

int32_t main() {
    //freopen("input.txt", "r", stdin);
    ios_base::sync_with_stdio(false);
    cin >> n >> m;
    for (int i = 0; i < m; ++i) {
        int u, v, c;
        cin >> u >> v >> c;
        --u; --v;
        g[u].push_back(edge_t(v, c, i));
        g[v].push_back(edge_t(u, c, i));
    }
    dijkstra(0);
    make_graph(n - 1);
#ifdef DEBUG
    for (int i = 0; i < n; ++i) {
        cout << i + 1 << " : ";
        for (int v : g1[i]) {
            cout << v + 1 << ' ';
        }
        cout << endl;
    }
#endif
    fill(used, used + n, false);
    dfs(0);
    cout << cut.size() << endl;
    for (int i : cut) {
        cout << i + 1 << ' ';
    }
    cout << endl;
    return 0;
}
